/*
 * Decompiled with CFR 0.152.
 */
package external;

import external.FunctionSupport;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.autoplot.RenderType;
import org.autoplot.ScriptContext2023;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.dom.Application;
import org.autoplot.dom.CanvasUtil;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.PyQDataSetAdapter;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.graph.DasColorBar;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.ClassMap;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PlotCommand
extends PyObject {
    private Application dom;
    private ScriptContext2023.State state;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");
    public static final PyString __doc__ = new PyString("<html><H2>plot([index],x,y,z,[named parameters])</H2>plot (or plotx) plots the data or URI for data on the canvas.\nSee https://autoplot.org/help.plotCommand<br>\n<br><b>named parameters:</b>\n<table><tr><td>xlog ylog zlog </td><td>explicitly set this axis to log (or linear when set equal to 0.).</td></tr>\n <tr><td> [xyz]title </td><td>set the label for the axis.</td></tr>\n <tr><td> index       </td><td>plot index\n</td></tr> <tr><td> title       </td><td>title for the plot\n</td></tr> <tr><td> renderType  </td><td> explcitly set the render type, to scatter, series, nnSpectrogram, digital, etc\n</td></tr> <tr><td> color      </td><td> the line colors.\n</td></tr> <tr><td> fillColor   </td><td>the color when filling volumes.\n</td></tr> <tr><td> colorTable  </td><td>the color table to use, like white_blue_black or black_red.\n</td></tr> <tr><td> symbolSize     </td><td>set the point (pixel) size\n</td></tr> <tr><td> symbolFill     </td><td>none, outline, or solid (solid is default)\n</td></tr> <tr><td> lineWidth   </td><td>deprecated--the line thickness in points (pixels)\n</td></tr> <tr><td> lineThick   </td><td>the line thickness in points (pixels)\n</td></tr> <tr><td> lineStyle   </td><td>the line style, one of solid,none,dotfine,dashfine</td></tr> <tr><td> symbol      </td><td>the symbol, e.g. dots triangles cross\n</td></tr> <tr><td> isotropic   </td><td>constrain the ratio between the x and y axes.\n</td></tr> <tr><td> legendLabel </td><td>add label to the legend</td></tr> <tr><td> title   </td><td>title for the plot\n</td></tr> <tr><td> xpos    </td><td>override horizontal position of plot, eg. '50%+1em,100%-2em'\n</td> <tr><td> ypos    </td><td>override vertical position of plot, eg. '0%+1em,25%-2em', 0 is top\n</td> <tr><td> [xy]drawTickLabels</td><td>False turns off the x or y tick labels for the plot\n</td> <tr><td> [xy]tickValues</td><td>explicitly control the tick locations.</td> <tr><td> [xyz]autoRangeHints</td><td>hints to the autorange, see https://autoplot.org/AxisAutoRangeHints\n</td> <tr><td> renderer</td><td>add custom renderer, a class extending org.das2.graph.Renderer, see https://autoplot.org/CustomRenderers</td> <tr><td> rightAxisOf</td><td>specify a plot where a new plot with a new yaxis.</td> <tr><td> topAxisOf</td><td>specify a plot where a new plot with a new xaxis above.</td> <tr><td> overplotOf</td><td>a plot or plot element with which this should share axes.  Note something should reset the plot!</td> <tr><td> reset=F</td><td>suppress autoranging, default is True</table></html>");
    public static final PyString __completions__;

    public PlotCommand(Application dom) {
        this.dom = dom;
        this.state = dom.getController().getScriptContextState();
    }

    private static QDataSet coerceIt(PyObject arg0) {
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            return JythonOps.dataset((PyObject)arg0);
        }
        QDataSet ds = (QDataSet)o;
        if (ds.rank() == 0) {
            return ds;
        }
        return ds;
    }

    private static boolean booleanValue(PyObject arg0) {
        if (arg0.isNumberType()) {
            return arg0.__nonzero__();
        }
        String s = String.valueOf(arg0);
        return s.equals("True") || s.equals("T") || s.equals("1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PyObject __call__(PyObject[] args, String[] keywords) {
        PyInteger False = Py.newBoolean((boolean)false);
        PyInteger True = Py.newBoolean((boolean)true);
        FunctionSupport fs = new FunctionSupport("plot", new String[]{"pos", "x", "y", "z", "xtitle", "xrange", "ytitle", "yrange", "ztitle", "zrange", "xscale", "yscale", "xlog", "ylog", "zlog", "title", "renderType", "color", "fillColor", "colorTable", "symbolSize", "lineWidth", "lineThick", "lineStyle", "symsize", "linewidth", "linethick", "linestyle", "legendLabel", "symbol", "symbolFill", "isotropic", "xpos", "ypos", "xdrawTickLabels", "ydrawTickLabels", "xautoRangeHints", "yautoRangeHints", "zautoRangeHints", "xtickValues", "ytickValues", "ztickValues", "renderer", "rightAxisOf", "topAxisOf", "overplotOf", "index", "reset"}, new PyObject[]{Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, False, False, False, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, True});
        fs.args(args, keywords);
        int nparm = args.length - keywords.length;
        if (nparm == 0) {
            logger.warning("args.length=0");
            return Py.None;
        }
        int iplot = 0;
        int nargs = nparm;
        boolean reset = true;
        PyObject po0 = args[0];
        if (po0 instanceof PyInteger) {
            iplot = ((PyInteger)po0).getValue();
            PyObject[] newArgs = new PyObject[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                newArgs[i] = args[i + 1];
            }
            args = newArgs;
            --nargs;
            nparm = args.length - keywords.length;
            po0 = args[0];
        }
        DomNode row = null;
        Column column = null;
        Plot plot = null;
        ScriptContext2023 scriptContext = this.dom.getController().getScriptContext();
        Application dom = scriptContext.getDocumentModel();
        String renderType = null;
        for (int i = 0; i < keywords.length; ++i) {
            DomNode n;
            DomNode n2;
            if (keywords[i].equals("renderType")) {
                renderType = args[i + nparm].toString();
                continue;
            }
            if (keywords[i].equals("column") || keywords[i].equals("xpos")) {
                String spec = args[i + nparm].toString();
                if (Ops.isSafeName((String)spec)) {
                    n2 = DomUtil.getElementById(dom, spec);
                    if (!(n2 instanceof Column)) throw new IllegalArgumentException("column named parameter is not the name of a column");
                    column = (Column)n2;
                } else if (args[i + nparm] instanceof PyString) {
                    column = dom.getCanvases(0).getController().maybeAddColumn(spec);
                } else {
                    try {
                        column = (Column)args[i + nparm].__tojava__(Column.class);
                    }
                    catch (Exception e) {
                        String columnId = ((Plot)args[i + nparm].__tojava__(Plot.class)).getColumnId();
                        n = DomUtil.getElementById(dom, columnId);
                        column = (Column)n;
                    }
                }
                if (row != null) continue;
                row = dom.getCanvases(0).getMarginRow();
                continue;
            }
            if (keywords[i].equals("row") || keywords[i].equals("ypos")) {
                String spec = args[i + nparm].toString();
                if (Ops.isSafeName((String)spec)) {
                    n2 = DomUtil.getElementById(dom, spec);
                    if (!(n2 instanceof Row)) throw new IllegalArgumentException("row named parameter is not the name of a row");
                    row = (Row)n2;
                } else if (args[i + nparm] instanceof PyString) {
                    row = dom.getCanvases(0).getController().maybeAddRow(spec);
                } else {
                    try {
                        row = (Row)args[i + nparm].__tojava__(Row.class);
                    }
                    catch (Exception e) {
                        String rowId = ((Plot)args[i + nparm].__tojava__(Plot.class)).getRowId();
                        n = DomUtil.getElementById(dom, rowId);
                        row = (Row)n;
                    }
                }
                if (column != null) continue;
                column = dom.getCanvases(0).getMarginColumn();
                continue;
            }
            if (keywords[i].equals("rightAxisOf") || keywords[i].equals("topAxisOf") || keywords[i].equals("overplotOf")) {
                Plot p;
                block107: {
                    String spec = args[i + nparm].toString();
                    p = null;
                    if (Ops.isSafeName((String)spec)) {
                        DomNode n3 = DomUtil.getElementById(dom, spec);
                        if (n3 instanceof PlotElement) {
                            n3 = DomUtil.getElementById(dom, ((PlotElement)n3).getPlotId());
                        }
                        p = (Plot)n3;
                    } else {
                        try {
                            p = (Plot)args[i + nparm].__tojava__(Plot.class);
                        }
                        catch (Exception e) {
                            Plot[] pe = (Plot[])args[i + nparm].__tojava__(PlotElement.class);
                            if (pe == null) break block107;
                            p = (Plot)DomUtil.getElementById(dom, pe.getPlotId());
                        }
                    }
                }
                if (p == null) {
                    throw new IllegalArgumentException("unable to identify plot");
                }
                Object underPlot = null;
                row = (Row)DomUtil.getElementById(dom, p.getRowId());
                column = (Column)DomUtil.getElementById(dom, p.getColumnId());
                if (keywords[i].equals("overplotOf")) {
                    plot = p;
                    iplot = dom.getDataSourceFilters().length;
                } else {
                    for (Plot p1 : dom.getPlots()) {
                        if (!p1.getRowId().equals(row.getId()) || !p1.getColumnId().equals(column.getId())) continue;
                        if (p1.getYaxis().isOpposite()) {
                            plot = p1;
                            continue;
                        }
                        underPlot = p1;
                    }
                }
                if (plot != null) continue;
                plot = dom.getController().addPlot((Row)row, column);
                if (keywords[i].equals("rightAxisOf")) {
                    plot.getYaxis().setOpposite(true);
                    dom.getController().bind(((Plot)underPlot).getXaxis(), "range", plot.getXaxis(), "range");
                    plot.getXaxis().setVisible(false);
                    continue;
                }
                if (!keywords[i].equals("topAxisOf")) continue;
                plot.getXaxis().setOpposite(true);
                dom.getController().bind(((Plot)underPlot).getYaxis(), "range", plot.getYaxis(), "range");
                plot.getYaxis().setVisible(false);
                continue;
            }
            if (keywords[i].equals("index")) {
                int sindex;
                iplot = sindex = Integer.parseInt(args[i + nparm].toString());
                continue;
            }
            if (keywords[i].equals("reset")) {
                reset = args[i + nparm].equals((Object)True);
                continue;
            }
            if (!keywords[i].equals("renderer")) continue;
            renderType = "internal";
        }
        if (row != null) {
            assert (column != null);
            Plot p = plot;
            if (p == null) {
                for (Plot p1 : dom.getPlots()) {
                    if (!p1.getRowId().equals(row.getId()) || !p1.getColumnId().equals(column.getId())) continue;
                    p = p1;
                }
            }
            if (p == null) {
                p = dom.getController().addPlot((Row)row, column);
            }
            while (dom.getDataSourceFilters().length <= iplot) {
                dom.getController().addDataSourceFilter();
            }
            PlotElement pe = dom.getController().addPlotElement(p, dom.getDataSourceFilters(iplot));
            List<PlotElement> pes = dom.getController().getPlotElementsFor(dom.getDataSourceFilters(iplot));
            pes.remove(pe);
            for (PlotElement rm : pes) {
                Plot prm = dom.getController().getPlotFor(rm);
                dom.getController().deletePlotElement(rm);
                if (!dom.getController().getPlotElementsFor(prm).isEmpty()) continue;
                dom.getController().deletePlot(prm);
            }
        }
        QDataSet[] qargs = new QDataSet[nargs];
        if (nargs == 1 && po0 instanceof PyString) {
            scriptContext.plot(iplot, ((PyString)po0).toString());
        } else if (nargs == 2 && po0 instanceof PyString && args[1] instanceof PyString) {
            DatumRange drtr = DatumRangeUtil.parseTimeRangeValid((String)((PyString)args[1]).toString());
            try {
                String uri = DataSourceUtil.setTimeRange((String)((PyString)po0).toString(), (DatumRange)drtr, (ProgressMonitor)new NullProgressMonitor());
                scriptContext.plot(iplot, uri);
            }
            catch (IOException | URISyntaxException | ParseException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            for (int i = 0; i < nargs; ++i) {
                QDataSet ds;
                qargs[i] = ds = PlotCommand.coerceIt(args[i]);
            }
            if (nargs == 1) {
                scriptContext.plot(iplot, null, null, qargs[0], renderType, reset);
            } else if (nargs == 2) {
                scriptContext.plot(iplot, null, qargs[0], qargs[1], renderType, reset);
            } else if (nargs == 3) {
                scriptContext.plot(iplot, null, qargs[0], qargs[1], qargs[2], renderType, reset);
            }
        }
        dom.getController().registerPendingChange((Object)this, (Object)this);
        dom.getController().performingChange((Object)this, (Object)this);
        try {
            int chNum = iplot;
            while (dom.getDataSourceFilters().length <= chNum) {
                Plot p = CanvasUtil.getMostBottomPlot(dom.getController().getCanvas());
                dom.getController().setPlot(p);
                dom.getController().addPlotElement(null, null);
            }
            DataSourceFilter dsf = dom.getDataSourceFilters(chNum);
            List<PlotElement> elements = dom.getController().getPlotElementsFor(dsf);
            if (elements.isEmpty()) {
                logger.log(Level.WARNING, "no elements found for data at index={0}", iplot);
                PyObject pyObject = Py.None;
                return pyObject;
            }
            PlotElement element = elements.get(0);
            plot = dom.getController().getPlotFor(element);
            plot.setIsotropic(false);
            for (int i = nparm; i < args.length; ++i) {
                PsymConnector p;
                Color c;
                DatumRange newRange;
                String kw = keywords[i - nparm];
                PyObject val = args[i];
                String sval = (String)val.__str__().__tojava__(String.class);
                if (kw.equals("ytitle")) {
                    plot.getYaxis().setLabel(sval);
                    continue;
                }
                if (kw.equals("yrange")) {
                    newRange = JythonOps.datumRange((PyObject)val, (Units)plot.getYaxis().getRange().getUnits());
                    if (plot.getYaxis().isLog() && newRange.min().doubleValue(newRange.getUnits()) < 0.0) {
                        plot.getYaxis().setLog(false);
                    }
                    plot.getYaxis().setRange(newRange);
                    continue;
                }
                if (kw.equals("ylog")) {
                    plot.getYaxis().setLog(PlotCommand.booleanValue(val));
                    continue;
                }
                if (kw.equals("yscale")) {
                    plot.getYaxis().setScale(JythonOps.datum((PyObject)val));
                    continue;
                }
                if (kw.equals("xtitle")) {
                    plot.getXaxis().setLabel(sval);
                    continue;
                }
                if (kw.equals("xrange")) {
                    newRange = JythonOps.datumRange((PyObject)val, (Units)plot.getXaxis().getRange().getUnits());
                    if (plot.getXaxis().isLog() && newRange.min().doubleValue(newRange.getUnits()) < 0.0) {
                        plot.getXaxis().setLog(false);
                    }
                    plot.getXaxis().setRange(newRange);
                    continue;
                }
                if (kw.equals("xlog")) {
                    plot.getXaxis().setLog(PlotCommand.booleanValue(val));
                    continue;
                }
                if (kw.equals("xscale")) {
                    plot.getXaxis().setScale(JythonOps.datum((PyObject)val));
                    continue;
                }
                if (kw.equals("ztitle")) {
                    plot.getZaxis().setLabel(sval);
                    continue;
                }
                if (kw.equals("zrange")) {
                    newRange = JythonOps.datumRange((PyObject)val, (Units)plot.getZaxis().getRange().getUnits());
                    if (plot.getZaxis().isLog() && newRange.min().doubleValue(newRange.getUnits()) < 0.0) {
                        plot.getZaxis().setLog(false);
                    }
                    plot.getZaxis().setRange(newRange);
                    continue;
                }
                if (kw.equals("zlog")) {
                    plot.getZaxis().setLog(PlotCommand.booleanValue(val));
                    continue;
                }
                if (kw.equals("color")) {
                    c = JythonOps.color((PyObject)val);
                    element.getStyle().setColor(c);
                    continue;
                }
                if (kw.equals("fillColor")) {
                    c = JythonOps.color((PyObject)val);
                    element.getStyle().setFillColor(c);
                    continue;
                }
                if (kw.equals("colorTable")) {
                    DasColorBar.Type t;
                    if (val.__tojava__(DasColorBar.Type.class) == Py.NoConversion) {
                        t = DasColorBar.Type.parse((String)sval);
                        element.getStyle().setColortable(t);
                        continue;
                    }
                    t = (DasColorBar.Type)val.__tojava__(DasColorBar.Type.class);
                    element.getStyle().setColortable(t);
                    continue;
                }
                if (kw.equals("title")) {
                    plot.setTitle(sval);
                    continue;
                }
                if (kw.equals("symsize") || kw.equals("symbolSize")) {
                    element.getStyle().setSymbolSize(Double.valueOf(sval));
                    continue;
                }
                if (kw.equals("symbolFill")) {
                    if (!(element.getController().getRenderer() instanceof SeriesRenderer)) continue;
                    FillStyle sfs = (FillStyle)ClassMap.getEnumElement(FillStyle.class, (String)sval);
                    ((SeriesRenderer)element.getController().getRenderer()).setFillStyle(sfs);
                    continue;
                }
                if (kw.equals("linewidth") || kw.equals("lineWidth")) {
                    element.getStyle().setLineWidth(Double.valueOf(sval));
                    continue;
                }
                if (kw.equals("linethick") || kw.equals("lineThick")) {
                    element.getStyle().setLineWidth(Double.valueOf(sval));
                    continue;
                }
                if (kw.equals("linestyle") || kw.equals("lineStyle")) {
                    p = (PsymConnector)ClassMap.getEnumElement(PsymConnector.class, (String)sval);
                    element.getStyle().setSymbolConnector(p);
                    continue;
                }
                if (kw.equals("symbol")) {
                    p = (PlotSymbol)ClassMap.getEnumElement(DefaultPlotSymbol.class, (String)sval);
                    if (p == null) throw new IllegalArgumentException("unable to identify symbol: " + sval);
                    element.getStyle().setPlotSymbol((PlotSymbol)p);
                    continue;
                }
                if (kw.equals("renderType")) {
                    String renderControl;
                    String srenderType = sval;
                    if (srenderType == null || srenderType.trim().length() <= 0) continue;
                    int ii = srenderType.indexOf(62);
                    if (ii == -1) {
                        renderControl = "";
                    } else {
                        renderControl = srenderType.substring(ii + 1);
                        srenderType = srenderType.substring(0, ii);
                    }
                    RenderType rt = RenderType.valueOf(srenderType);
                    element.setRenderType(rt);
                    element.setRenderControl(renderControl);
                    continue;
                }
                if (kw.equals("renderer")) {
                    if (val.__tojava__(Renderer.class) != Py.NoConversion) {
                        Renderer oldRenderer = element.getController().getRenderer();
                        String control = oldRenderer.getControl();
                        Renderer r = (Renderer)val.__tojava__(Renderer.class);
                        QDataSet ds1 = null;
                        switch (nargs) {
                            case 1: {
                                ds1 = qargs[0];
                                break;
                            }
                            case 2: {
                                ds1 = Ops.link((QDataSet)qargs[0], (QDataSet)qargs[1]);
                                break;
                            }
                            case 3: {
                                ds1 = Ops.link((QDataSet)qargs[0], (QDataSet)qargs[1], (QDataSet)qargs[2]);
                                break;
                            }
                        }
                        PyObject doAuto = val.__findattr__("doAutorange");
                        if (doAuto == null) {
                            doAuto = val.__findattr__("autorange");
                        }
                        if (doAuto != null && doAuto != Py.None && ds1 != null) {
                            PyObject range = ((PyMethod)doAuto).__call__(new PyQDataSetAdapter().adapt((Object)ds1));
                            QDataSet rangeds = (QDataSet)range.__tojava__(QDataSet.class);
                            plot.getXaxis().setRange(DataSetUtil.asDatumRange((QDataSet)rangeds.slice(0)));
                            if (rangeds.length() > 1) {
                                plot.getYaxis().setRange(DataSetUtil.asDatumRange((QDataSet)rangeds.slice(1)));
                            }
                            if (rangeds.length() > 2) {
                                plot.getZaxis().setRange(DataSetUtil.asDatumRange((QDataSet)rangeds.slice(2)));
                            }
                        }
                        plot.getController().getDasPlot().removeRenderer(oldRenderer);
                        plot.getController().getDasPlot().addRenderer(r);
                        r.setDataSet(ds1);
                        r.setColorBar((DasColorBar)plot.getZaxis().getController().getDasAxis());
                        element.getController().setRenderer(r);
                        element.setRenderType(RenderType.internal);
                        r.setControl(control);
                        continue;
                    }
                    logger.warning("no conversion for renderer");
                    continue;
                }
                if (kw.equals("legendLabel")) {
                    if (sval.equals("")) continue;
                    element.setLegendLabel(sval);
                    element.setDisplayLegend(true);
                    continue;
                }
                if (kw.equals("isotropic")) {
                    plot.setIsotropic(true);
                    continue;
                }
                if (kw.equals("xdrawTickLabels")) {
                    plot.getXaxis().setDrawTickLabels(PlotCommand.booleanValue(val));
                    continue;
                }
                if (kw.equals("ydrawTickLabels")) {
                    plot.getYaxis().setDrawTickLabels(PlotCommand.booleanValue(val));
                    continue;
                }
                if (kw.equals("xtickValues")) {
                    plot.getXaxis().setTickValues(sval);
                    continue;
                }
                if (kw.equals("ytickValues")) {
                    plot.getYaxis().setTickValues(sval);
                    continue;
                }
                if (kw.equals("ztickValues")) {
                    plot.getZaxis().setTickValues(sval);
                    continue;
                }
                if (kw.equals("xautoRangeHints")) {
                    plot.getXaxis().setAutoRangeHints(sval);
                    continue;
                }
                if (kw.equals("yautoRangeHints")) {
                    plot.getYaxis().setAutoRangeHints(sval);
                    continue;
                }
                if (!kw.equals("zautoRangeHints")) continue;
                plot.getZaxis().setAutoRangeHints(sval);
            }
            Plot fplot = plot;
            PlotElement fplotElement = element;
            return new PyList(new PyObject[]{new PyJavaInstance((Object)fplot), new PyJavaInstance((Object)fplotElement)});
        }
        finally {
            dom.getController().changePerformed((Object)this, (Object)this);
        }
    }

    static {
        String text = new BufferedReader(new InputStreamReader(PlotCommand.class.getResourceAsStream("PlotCommand.json"), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        __completions__ = new PyString(text);
    }
}

